<?php
    /**
    *
    * copyright (c) 2013-2018 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    * 	Classe che gestisce i javascript nelle varie pagine di Geecom
    *   Usata ad esempio per inserire i javascript degli slider che hanno caratteristiche proprie
    * 
    *   Grazie al metodo aggiungiJavascript viene inserito il codice e il metodo stampaJavascript li
    *   stampa al momento opportuno
    *   
    */

    class GestoreJavascript {
        private $sonoPresentiSlider;
        private $codiciJavascript;
        private $arrayLink;
        
        function __construct() {
            $this->sonoPresentiSlider = false;
            $this->codiciJavascript = array();
            $this->arrayLink = array();
        }
        
        function aggiungiJavascript($codice) {
            $this->codiciJavascript[count($this->codiciJavascript)] = $codice;
        }
        
        function aggiungiLinkJavascript($link) {
            $this->arrayLink[count($this->arrayLink)] = $link;
        }
        
        function stampaJavascript() {
            if($this->sonoPresentiSlider) {
                echo"<script src=\"plugins/OwlCarousel2/owl.carousel.min.js\"></script>";
            }
            
            foreach($this->arrayLink as $link) {
                echo "$link\n";
            }
            
            foreach($this->codiciJavascript as $codice) {
                echo "$codice\n";
            }
        }

        function getSonoPresentiSlider() {
            return $this->sonoPresentiSlider;
        }

        function setSonoPresentiSlider($sonoPresentiSlider) {
            $this->sonoPresentiSlider = $sonoPresentiSlider;
        }
    }
